/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap;

import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.util.logging.Logger;
import uncertain.core.IGlobalInstance;

public class SapInstance
implements IGlobalInstance {
    public static final String LOGGING_TOPIC = "aurora.plugin.sap";
    public String SID;
    public String USERID;
    public String PASSWORD;
    public String SERVER_IP;
    public String DEFAULT_LANG;
    public int MAX_CONN;
    public String SAP_CLIENT;
    public String SYSTEM_NUMBER;
    Logger logger;
    IRepository repository;
    private boolean inited = false;

    public SapInstance() {
    }

    public SapInstance(Logger logger) {
        this.logger = logger;
    }

    public void prepare() {
        if (!this.inited) {
            JCO.addClientPool((String)this.SID, (int)this.MAX_CONN, (String)this.SAP_CLIENT, (String)this.USERID, (String)this.PASSWORD, (String)this.DEFAULT_LANG, (String)this.SERVER_IP, (String)this.SYSTEM_NUMBER);
            this.repository = JCO.createRepository((String)"MYRepository", (String)this.SID);
            if (this.logger != null) {
                this.logger.info("SAP connection pool " + this.SID + " created");
            }
            this.inited = true;
        }
    }

    public IRepository getRepository() {
        if (!this.inited) {
            this.prepare();
        }
        if (this.repository == null) {
            throw new RuntimeException("SAP connection pool can't be created");
        }
        return this.repository;
    }

    public void release() {
        JCO.removeClientPool((String)this.SID);
        if (this.logger != null) {
            this.logger.info("SAP connection pool " + this.SID + " released");
        }
        this.inited = false;
    }

    public JCO.Client getClient() {
        if (!this.inited) {
            this.prepare();
        }
        JCO.Client client = JCO.getClientPoolManager().getClient(this.SID);
        return client;
    }

    public void onShutdown() {
        this.release();
    }
}

