/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap;

import aurora.plugin.sap.Parameter;
import aurora.plugin.sap.SapInstance;
import aurora.plugin.sap.Structure;
import aurora.plugin.sap.Table;
import aurora.service.http.HttpServiceInstance;
import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.ConfigurationError;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class JcoInvoke
extends AbstractEntry {
    SapInstance sapInstance;
    ILogger logger;
    public Parameter[] Parameters;
    public Table[] Tables;
    public Structure[] Structures;
    public String Function;
    public String Return_target;

    public JcoInvoke(SapInstance si) {
        this.sapInstance = si;
    }

    public void run(ProcedureRunner runner) throws Exception {
        JCO.Client client;
        block32: {
            String t;
            CompositeMap context = runner.getContext();
            this.logger = LoggingContext.getLogger((CompositeMap)context, (String)"aurora.plugin.sap");
            this.logger.config("jco-invoke");
            this.logger.config("===================================");
            this.logger.log(Level.CONFIG, "config:{0}", new Object[]{this});
            HttpServiceInstance service = (HttpServiceInstance)HttpServiceInstance.getInstance((CompositeMap)context.getRoot());
            CompositeMap target = null;
            CompositeMap model = null;
            model = service != null ? service.getServiceContext().getModel() : context.getRoot().getChild("model");
            if (model == null) {
                model = context.getRoot().createChild("model");
            }
            if (this.Return_target != null && (target = (CompositeMap)model.getObject(t = TextParser.parse((String)this.Return_target, (CompositeMap)context))) == null) {
                target = model.createChildByTag(t);
            }
            IRepository repository = this.sapInstance.getRepository();
            client = null;
            try {
                IFunctionTemplate ftemplate = repository.getFunctionTemplate(this.Function);
                this.logger.info("function template:" + this.Function);
                if (ftemplate != null) {
                    Table table;
                    JCO.Structure stc;
                    int i;
                    JCO.Function function = ftemplate.getFunction();
                    client = this.sapInstance.getClient();
                    this.logger.config("connected to " + this.sapInstance.SERVER_IP + ":" + this.sapInstance.SID);
                    JCO.ParameterList input = function.getImportParameterList();
                    JCO.ParameterList output = function.getExportParameterList();
                    if (this.Parameters != null) {
                        i = 0;
                        while (i < this.Parameters.length) {
                            Parameter param = this.Parameters[i];
                            if (param.Return_field == null) {
                                String o = param.Source_field == null ? param.Value : context.getObject(param.Source_field);
                                String value = o == null ? "" : o.toString();
                                input.setValue(value, param.Name);
                                this.logger.log(Level.CONFIG, "parameter {0} -> {1}", new Object[]{param.Name, value});
                            }
                            ++i;
                        }
                    }
                    if (this.Structures != null) {
                        i = 0;
                        while (i < this.Structures.length) {
                            Structure structure = this.Structures[i];
                            structure.setLogger(this.logger);
                            if (structure.isImport()) {
                                stc = structure.getJCOStructure(input);
                                structure.fillJCOStructure(stc, context);
                                input.setValue(stc, structure.Name);
                            }
                            ++i;
                        }
                    }
                    if (this.Tables != null) {
                        JCO.ParameterList list = function.getTableParameterList();
                        int i2 = 0;
                        while (i2 < this.Tables.length) {
                            table = this.Tables[i2];
                            table.setLogger(this.logger);
                            if (table.isImport()) {
                                JCO.Table tbl = table.getJCOTable(list);
                                Object o = context.getObject(table.Source_field);
                                this.logger.config("transfer import table " + table.Name + " from '" + table.Source_field + "':" + o);
                                if (o instanceof CompositeMap) {
                                    table.fillJCOTable(tbl, context);
                                }
                            }
                            ++i2;
                        }
                    }
                    this.logger.config("call function " + this.Function);
                    client.execute(function);
                    if (this.Parameters != null) {
                        int i3 = 0;
                        while (i3 < this.Parameters.length) {
                            Parameter param = this.Parameters[i3];
                            if (param.Return_field != null) {
                                if (target == null) {
                                    throw new ConfigurationError("<jco-invoke>:must set 'return_target' attribute if there is return field");
                                }
                                String vl = output.getString(param.Name);
                                if (vl == null && !param.Nullable) {
                                    throw new IllegalArgumentException("jco-invoke: return field " + param.Name + " is null");
                                }
                                String f = TextParser.parse((String)param.Return_field, (CompositeMap)context);
                                target.putObject(f, (Object)vl);
                                this.logger.config("return: " + param.Name + "=" + vl + " -> " + f);
                            }
                            ++i3;
                        }
                    }
                    if (this.Structures != null) {
                        int i4 = 0;
                        while (i4 < this.Structures.length) {
                            Structure structure = this.Structures[i4];
                            structure.setLogger(this.logger);
                            if (!structure.isImport()) {
                                if (structure.Target == null) {
                                    throw new ConfigurationError("Must set 'target' attribute for Structures " + structure.Name);
                                }
                                stc = structure.getJCOStructure(output);
                                CompositeMap result = (CompositeMap)context.getObject(structure.Target);
                                if (result == null) {
                                    result = context.createChildByTag(structure.Target);
                                }
                                structure.fillCompositeMap(stc, result);
                            }
                            ++i4;
                        }
                    }
                    if (this.Tables != null) {
                        JCO.ParameterList list = function.getTableParameterList();
                        if (list == null) {
                            throw new IllegalArgumentException("Function '" + this.Function + "' doesn't return tables");
                        }
                        int i5 = 0;
                        while (i5 < this.Tables.length) {
                            table = this.Tables[i5];
                            if (!table.isImport()) {
                                if (table.Target == null) {
                                    throw new ConfigurationError("Must set 'target' attribute for table " + table.Name);
                                }
                                table.setLogger(this.logger);
                                JCO.Table records = table.getJCOTable(list);
                                CompositeMap result = (CompositeMap)context.getObject(table.Target);
                                if (result == null) {
                                    result = context.createChildByTag(table.Target);
                                }
                                table.fillCompositeMap(records, result);
                                int rc = 0;
                                if (result.getChilds() != null) {
                                    rc = result.getChilds().size();
                                }
                                this.logger.config("loading export table " + table.Name + " into path '" + table.Target + "', total " + rc + " record(s)");
                            }
                            ++i5;
                        }
                    }
                    this.logger.config("jco invoke finished");
                    break block32;
                }
                throw new IllegalArgumentException("Function '" + this.Function + "' not found in SAP system.");
            }
            catch (Throwable throwable) {
                JCO.releaseClient(client);
                throw throwable;
            }
        }
        JCO.releaseClient((JCO.Client)client);
    }
}

