/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.swt.util;

import aurora.ide.swt.util.PageModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class UWizardPage
extends WizardPage {
    private PageModel model = new PageModel();
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            UWizardPage.this.modelChanged(evt.getPropertyName(), evt.getNewValue());
        }
    };

    public UWizardPage(String pageName) {
        super(pageName);
        this.init();
    }

    protected abstract String[] getModelPropertyKeys();

    protected void modelChanged(String key, Object value) {
        this.modelChanged();
    }

    protected void modelChanged() {
        String[] keys = this.getModelPropertyKeys();
        if (keys != null) {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                Object val = this.model.getPropertyValue(k);
                String errMSG = this.verifyModelProperty(k, val);
                if (!this.verifyPage(errMSG)) break;
                ++n2;
            }
        }
    }

    protected abstract String verifyModelProperty(String var1, Object var2);

    public boolean verifyPage(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
        return message == null;
    }

    protected void updateModel(String key, Object value) {
        this.model.setPropertyValue(key, value);
    }

    protected void init() {
        this.model.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void createControl(Composite parent) {
        Composite c = this.createPageControl(parent);
        this.setControl((Control)c);
        this.modelChanged();
    }

    protected abstract Composite createPageControl(Composite var1);

    public PageModel getModel() {
        return this.model;
    }

    public void setModel(PageModel model) {
        this.model = model;
    }

    protected class TextModifyListener
    implements ModifyListener {
        private String key;
        private Text text;

        public TextModifyListener(String key, Text text) {
            this.key = key;
            this.text = text;
        }

        public void modifyText(ModifyEvent e) {
            UWizardPage.this.updateModel(this.key, this.text.getText());
        }
    }
}

